/*
 * Decompiled with CFR 0.152.
 */
package com.github.monun.survival.tap.fake.internal;

import com.github.monun.survival.tap.fake.FakeEntity;
import com.github.monun.survival.tap.fake.FakeEntityServer;
import com.github.monun.survival.tap.fake.FakeSupportKt;
import com.github.monun.survival.tap.fake.internal.FakeEntityImpl;
import com.github.monun.survival.tap.fake.internal.FakeTracker;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u00014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001bH\u0016J\u0006\u0010!\u001a\u00020\u001fJ\b\u0010\"\u001a\u00020\u001fH\u0016J\u0015\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b%J\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001bH\u0016J\b\u0010'\u001a\u00020\u001fH\u0016J \u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020*2\u000e\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020-0,H\u0016J\u0018\u0010.\u001a\u00020\r2\u0006\u0010)\u001a\u00020*2\u0006\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020\u001fH\u0016J\b\u00102\u001a\u00020\u001fH\u0002J\b\u00103\u001a\u00020\u001fH\u0002R$\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00160\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/github/monun/survival/tap/fake/internal/FakeEntityServerImpl;", "Lcom/github/monun/survival/tap/fake/FakeEntityServer;", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "(Lorg/bukkit/plugin/java/JavaPlugin;)V", "_entities", "Ljava/util/ArrayList;", "Lcom/github/monun/survival/tap/fake/internal/FakeEntityImpl;", "Lkotlin/collections/ArrayList;", "get_entities$api", "()Ljava/util/ArrayList;", "entities", "", "Lcom/github/monun/survival/tap/fake/FakeEntity;", "getEntities", "()Ljava/util/List;", "isRunning", "", "listener", "Lcom/github/monun/survival/tap/fake/internal/FakeEntityServerImpl$FakeListener;", "trackers", "", "Lcom/github/monun/survival/tap/fake/internal/FakeTracker;", "getTrackers$api", "()Ljava/util/Collection;", "trackersByPlayer", "Ljava/util/WeakHashMap;", "Lorg/bukkit/entity/Player;", "updateQueue", "Ljava/util/ArrayDeque;", "addPlayer", "", "player", "checkState", "clear", "enqueue", "entity", "enqueue$api", "removePlayer", "shutdown", "spawnEntity", "location", "Lorg/bukkit/Location;", "clazz", "Ljava/lang/Class;", "Lorg/bukkit/entity/Entity;", "spawnFallingBlock", "blockData", "Lorg/bukkit/block/data/BlockData;", "update", "updateEntities", "updateTrackers", "FakeListener", "api"})
public final class FakeEntityServerImpl
implements FakeEntityServer {
    @NotNull
    private final ArrayList<FakeEntityImpl> _entities;
    private final ArrayDeque<FakeEntityImpl> updateQueue;
    private final WeakHashMap<Player, FakeTracker> trackersByPlayer;
    private final FakeListener listener;
    private boolean isRunning;

    @NotNull
    public final ArrayList<FakeEntityImpl> get_entities$api() {
        return this._entities;
    }

    @Override
    @NotNull
    public List<FakeEntity> getEntities() {
        ImmutableList immutableList = ImmutableList.copyOf((Collection)this._entities);
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"ImmutableList.copyOf(_entities)");
        return (List)immutableList;
    }

    @NotNull
    public final Collection<FakeTracker> getTrackers$api() {
        Collection<FakeTracker> collection = this.trackersByPlayer.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"trackersByPlayer.values");
        return collection;
    }

    @Override
    @NotNull
    public FakeEntity spawnEntity(@NotNull Location location, @NotNull Class<? extends Entity> clazz) {
        World bukkitWorld;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        this.checkState();
        World world = bukkitWorld = location.getWorld();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"bukkitWorld");
        Entity entity = FakeSupportKt.createFakeEntity(clazz, world);
        boolean bl = false;
        boolean bl2 = false;
        if (entity == null) {
            boolean bl3 = false;
            String string2 = "Cannot create entity " + clazz;
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        bl = false;
        bl2 = false;
        Entity $this$apply = entity;
        boolean bl4 = false;
        FakeSupportKt.setLocation($this$apply, location);
        Entity bukkitEntity = entity;
        FakeEntityImpl fakeEntity = new FakeEntityImpl(this, bukkitEntity, location);
        Collection collection = this._entities;
        bl2 = false;
        collection.add(fakeEntity);
        this.enqueue$api(fakeEntity);
        return fakeEntity;
    }

    @Override
    @NotNull
    public FakeEntity spawnFallingBlock(@NotNull Location location, @NotNull BlockData blockData) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)blockData, (String)"blockData");
        FallingBlock bukkitFallingBlock = FakeSupportKt.createFallingBlock(blockData);
        FakeEntityImpl fakeEntity = new FakeEntityImpl(this, (Entity)bukkitFallingBlock, location);
        Collection collection = this._entities;
        boolean bl = false;
        collection.add(fakeEntity);
        this.enqueue$api(fakeEntity);
        return fakeEntity;
    }

    @Override
    public void addPlayer(@NotNull Player player2) {
        Intrinsics.checkNotNullParameter((Object)player2, (String)"player");
        this.checkState();
        this.trackersByPlayer.computeIfAbsent(player2, new Function<Player, FakeTracker>(this){
            final /* synthetic */ FakeEntityServerImpl this$0;

            public final FakeTracker apply(Player it) {
                Player player2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"it");
                FakeTracker fakeTracker = new FakeTracker(this.this$0, player2);
                boolean bl = false;
                boolean bl2 = false;
                FakeTracker $this$apply = fakeTracker;
                boolean bl3 = false;
                $this$apply.broadcastSelf$api();
                return fakeTracker;
            }
            {
                this.this$0 = fakeEntityServerImpl;
            }
        });
    }

    @Override
    public void removePlayer(@NotNull Player player2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)player2, (String)"player");
            FakeTracker fakeTracker = this.trackersByPlayer.remove(player2);
            if (fakeTracker == null) break block0;
            fakeTracker.destroy$api();
        }
    }

    @Override
    public void update() {
        this.checkState();
        this.updateTrackers();
        this.updateEntities();
    }

    private final void updateTrackers() {
        Iterator<Map.Entry<Player, FakeTracker>> iterator = this.trackersByPlayer.entrySet().iterator();
        boolean bl = false;
        boolean bl2 = false;
        Iterator<Map.Entry<Player, FakeTracker>> iterator2 = iterator;
        boolean bl3 = false;
        while (iterator2.hasNext()) {
            Map.Entry<Player, FakeTracker> entry;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), (String)"iterator.next()");
            FakeTracker tracker = entry.getValue();
            tracker.update();
        }
    }

    private final void updateEntities() {
        ArrayDeque<FakeEntityImpl> updateQueue = this.updateQueue;
        FakeEntityImpl nextTickEntity = null;
        while (true) {
            FakeEntityImpl entity;
            Collection collection = updateQueue;
            boolean bl = false;
            if (!(!collection.isEmpty()) || (entity = updateQueue.peek()) == nextTickEntity) break;
            updateQueue.remove();
            entity.update$api();
            if (!entity.getValid()) {
                this._entities.remove(entity);
                continue;
            }
            if (entity.isDone()) continue;
            if (nextTickEntity == null) {
                nextTickEntity = entity;
            }
            entity.enqueue$api();
        }
    }

    @Override
    public void clear() {
        this.updateQueue.clear();
        Object object = this.trackersByPlayer;
        boolean bl = false;
        boolean bl2 = false;
        WeakHashMap<Player, FakeTracker> $this$run = object;
        boolean bl3 = false;
        for (FakeTracker tracker : $this$run.values()) {
            tracker.clearEntities$api();
        }
        $this$run.clear();
        object = this._entities;
        bl = false;
        bl2 = false;
        Object $this$apply = object;
        boolean bl4 = false;
        Iterator<FakeTracker> iterator = ((ArrayList)$this$apply).iterator();
        while (iterator.hasNext()) {
            FakeEntityImpl entity = (FakeEntityImpl)((Object)iterator.next());
            entity.despawn$api();
            entity.clearTrackers$api();
        }
        ((ArrayList)$this$apply).clear();
    }

    public final void checkState() {
        boolean bl = this.isRunning;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            StringBuilder stringBuilder = new StringBuilder().append("Invalid ").append(this.getClass().getSimpleName()).append('@');
            int n = System.identityHashCode(this);
            int n2 = 16;
            boolean bl5 = false;
            String string2 = Integer.toString(n, CharsKt.checkRadix((int)n2));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
            String string3 = stringBuilder.append(string2).toString();
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
    }

    @Override
    public void shutdown() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        this.clear();
        HandlerList.unregisterAll((Listener)this.listener);
    }

    public final void enqueue$api(@NotNull FakeEntityImpl entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.updateQueue.offer(entity);
    }

    public FakeEntityServerImpl(@NotNull JavaPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        this._entities = new ArrayList();
        this.updateQueue = new ArrayDeque();
        this.trackersByPlayer = new WeakHashMap();
        this.listener = new FakeListener();
        this.isRunning = true;
        Bukkit.getPluginManager().registerEvents((Listener)this.listener, (Plugin)plugin);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lcom/github/monun/survival/tap/fake/internal/FakeEntityServerImpl$FakeListener;", "Lorg/bukkit/event/Listener;", "(Lcom/github/monun/tap/fake/internal/FakeEntityServerImpl;)V", "onPlayerDeath", "", "event", "Lorg/bukkit/event/entity/PlayerDeathEvent;", "onPlayerQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "api"})
    public final class FakeListener
    implements Listener {
        @EventHandler
        public final void onPlayerDeath(@NotNull PlayerDeathEvent event) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                FakeTracker fakeTracker = (FakeTracker)FakeEntityServerImpl.this.trackersByPlayer.get(event.getEntity());
                if (fakeTracker == null) break block0;
                fakeTracker.clear$api();
            }
        }

        @EventHandler
        public final void onPlayerQuit(@NotNull PlayerQuitEvent event) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                FakeTracker fakeTracker = (FakeTracker)FakeEntityServerImpl.this.trackersByPlayer.remove(event.getPlayer());
                if (fakeTracker == null) break block0;
                fakeTracker.clear$api();
            }
        }
    }
}

